<?php
include("./components/head.php");
include './pricing_data.php';
?>

<style>
  .pricing_navbar {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
  }

  .pricing_navbar li a {
    position: relative;
    display: block;
    z-index: 9;
    border: 1px solid #ccc;
    color: #000;
    background-color: #ccc;
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 1.5px;
    font-weight: 500;
    padding: 8px 20px;
    margin-bottom: 10px;
  }

  .pricing_navbar .refresh {
    font-size: 18px;
    padding: 4px 10px;
    line-height: 35px;
  }

  .pricing_navbar li a:where(:hover, :focus, .active) {
    background-color: #004dff;
    border-color: #004dff;
    color: #fff;
  }
</style>

<body class="bg-dark">

  <?php include("./components/preloader.php"); ?>

  <?php $navClass = "nav2";
  include("./components/navbar.php"); ?>

  <div class="banner-style-three" style="background-image: url(assets/img/shape/7.png);">
    <div class="container">
      <div class="row align-center">
        <div class="col-lg-5">
          <div class="fun-fact">
            <div class="counter">
              <div class="timer" data-to="38" data-speed="2000">38</div>
              <div class="operator">K</div>
            </div>
            <span class="medium">Completed Projects</span>
          </div>
          <div class="thumb">
            <img src="assets/img/services.jpg" alt="Image Not Found">
          </div>
        </div>
        <div class="col-lg-7">
          <div class="content">
            <h2>Better design for your digital products.</h2>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Pricing -->
  <div class="pricing-style-one-area default-padding bg-gray">
    <div class="shape-left-top">
      <img src="assets/img/shape/11.png" alt="Image Not Found">
    </div>
    <div class="container">
      <div class="pricing-items">
        <div class="row align-center justify-content-between">
          <div class="col-xl-6 col-lg-5">
            <h4 class="sub-title">Best Pricing</h4>
            <h2 class="title">Complete Design Solutions at Reasonable Costs</h2>
          </div>
          <div class="col-xl-5 col-lg-6">
            <p class="my-0">
              At Savy Design Hub, we believe in offering Simple and flexible pricing that aligns perfectly with your
              needs. Whether you’re seeking a comprehensive digital strategy or targeted solutions, our pricing plans
              are meticulously designed to deliver exceptional value and ensure that you get the most out of your
              investment.
            </p>
            <h5>Join today and get <strong>50%</strong> Off</h5>
          </div>
        </div>
        <div class="row mb-70 mt-50">
          <div class="col-12">
            <div class="pricing_nav">
              <ul class="pricing_navbar">
                <?php foreach ($pricingPackages as $filter => $packages) {
                  $filterName = ucwords(str_replace('_', ' ', $filter)); ?>
                  <li>
                    <a class="filternav" href="javascript:void(0);" data-filter="<?= $filter ?>">
                      <?= $filterName ?></a>
                  </li>
                <?php } ?>
              </ul>
            </div>
          </div>
        </div>
        <div class="row justify-content-center r-gap-30">
          <?php
          foreach ($pricingPackages as $category => $packages) {
            foreach ($packages as $package) {
              $packageId = $package['id'];
              $type = isset($packageTypes[$category][$packageId]) ? $packageTypes[$category][$packageId] : '';
              $pkgClass = '';
              if ($type === 'best') {
                $pkgClass = 'green';
              } elseif ($type === 'orange') {
                $pkgClass = 'orange';
              }

          ?>
              <div class="col-12 col-lg-4 filterCategory" data-category="<?= $category ?>">
                <div class="pricing-item <?= $pkgClass ?>">
                  <div class="pricing-header">
                    <h3 class="pricing-title"><?= $package['name'] ?></h3>
                    <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Dolorum, illo.</p>
                  </div>
                  <div class="pricing-body">
                    <div class="pricing-features">
                      <ul>
                        <?php foreach ($package['features'] as $feature) { ?>
                          <li><?= $feature ?></li>
                        <?php } ?>
                      </ul>
                    </div>
                    <div class="pricing-price">
                      <h3 class="price">
                        <span>$</span>
                        <?= number_format((float) $package['discounted_price'], 2, '.', '') ?>
                      </h3>
                    </div>
                  </div>
                  <div class="pricing-footer d-flex flex-column">
                    <a class="btn btn-sm circle btn-border" href="<?= $package['url'] ?>">Order Now</a>
                    <a class="view" href="<?= $package['url'] ?>">View Details</a>
                  </div>
                </div>
              </div>
          <?php
            }
          }
          ?>
        </div>
      </div>
    </div>
  </div>

  <?php include("./components/clients_area.php"); ?>

  <?php include("./components/footer.php"); ?>

  <?php include("./components/js-scripts.php"); ?>
